<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installer</title>
<style>
    ::-webkit-scrollbar,
::-webkit-scrollbar {
  width: 6px;
  height: 6px;
  -webkit-transition: background 0.3s;
  transition: background 0.3s;
}
@media (prefers-reduced-motion: reduce) {
  ::-webkit-scrollbar,
::-webkit-scrollbar {
    -webkit-transition: none;
    transition: none;
  }
}
::-webkit-scrollbar-thumb,
::-webkit-scrollbar-thumb {
  border-radius: 5px;
  background: white;
}
::-webkit-scrollbar-track,
::-webkit-scrollbar-track {
  background: rgba(var(--tblr-body-color-rgb), 0.06);
}
::-webkit-scrollbar-thumb,
::-webkit-scrollbar-thumb {
  background: white;
}

* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
  list-style: none;
}

:root {
    --color-primary: #FFFFFF;
  --color-secondary: #F56692;
  --color-white: #454e56;
  --color-black: #000;
  --color-grey0: #f8f8f8;
  --color-grey-1: #6c7983;
  --color-grey-2: #6c7983;
  --color-grey-3: #6c7983;
  --color-grey-4: #454e56;
  --color-grey-5: #f8f8f8;
  --color-grey-6: #12181b;
}

body {
  background-color: var(--color-primary);
  font-family: "Poppins", sans-serif;
  font-size: 1.1rem;
  color: var(--color-white);
  transition: all 0.4s ease-in-out;
}

a {
  display: inline-block;
  text-decoration: none;
  color: inherit;
  font-family: inherit;
}

header {
  min-height: 100vh;
  color: var(--color-white);
  overflow: hidden;
  padding: 0 !important;
}

section {
  min-height: 100vh;
  width: 100%;
  position: absolute;
  left: 0;
  top: 0;
  padding: 3rem 18rem;
}

.container {
  display: none;
  transform: translateY(-100%) scale(0);
  transition: all 0.4s ease-in-out;
  background-color: var(--color-primary);
}

.active {
  display: block;
  animation: appear 1s ease-in-out;
  transform: translateY(0) scaleY(1);
}
@keyframes appear {
  0% {
    transform: translateY(-100%) scaleY(0);
  }
  100% {
    transform: translateY(0) scaleY(1);
  }
}

.btn-con {
  display: flex;
  align-self: flex-start;
}

.main-btn {
  border-radius: 30px;
  color: inherit;
  font-weight: 600;
  position: relative;
  border: 1px solid var(--color-secondary);
  display: flex;
  align-self: flex-start;
  align-items: center;
  overflow: hidden;
}
.main-btn .btn-text {
  padding: 0 2rem;
}
.main-btn .btn-icon {
  background-color: var(--color-secondary);
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 50%;
  padding: 1rem;
}
.main-btn::before {
  content: "";
  position: absolute;
  top: 0;
  right: 0;
  transform: translateX(100%);
  transition: all 0.4s ease-out;
  z-index: -1;
}
.main-btn:hover {
  transition: all 0.4s ease-out;
}
.main-btn:hover::before {
  width: 100%;
  height: 100%;
  background-color: var(--color-secondary);
  transform: translateX(0);
  transition: all 0.4s ease-out;
}

.main-title {
  text-align: center;
}
.main-title h2 {
  position: relative;
  text-transform: uppercase;
  font-size: 4rem;
  font-weight: 700;
}
.main-title h2 span {
  color: var(--color-secondary);
}
.main-title h2 .bg-text {
  position: absolute;
  top: 50%;
  left: 50%;
  color: var(--color-grey-5);
  transition: all 0.4s ease-in-out;
  z-index: -1;
  transform: translate(-50%, -50%);
  font-weight: 800;
  font-size: 6.3rem;
}

@media screen and (max-width: 600px) {
  header {
    padding: 0 !important;
  }

  .container {
    padding: 2rem 2.5rem !important;
  }

  .main-title h2 {
    font-size: 2rem;
  }
  .main-title h2 span {
    font-size: 2.3rem;
  }
  .main-title h2 .bg-text {
    font-size: 2.3rem;
  }
}
    </style>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" integrity="sha512-1ycn6IcaQQ40/MKBW2W4Rhis/DbILU74C1vSrLJxCq57o941Ym01SwNsOMqvEBFlcgUa6xLiPY/NS5R+E6ztJQ==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/sweetalert2@11.7.3/dist/sweetalert2.all.min.js"></script>
</head>
<body class="main-content">
<?php
if(isset($_POST["install_submit"])) {
$get_mysql_host = $_POST["mysql_host"];
$get_mysql_username = $_POST["mysql_username"];
$get_mysql_dbname = $_POST["mysql_dbname"];
$get_mysql_password = $_POST["mysql_password"];

$get_admin_username = $_POST["admin_username"];
$get_admin_email = $_POST["admin_email"];
$get_admin_password = password_hash($_POST["admin_password"], PASSWORD_BCRYPT);
$get_script_user = $_POST["script_user"];
$conn = mysqli_connect($get_mysql_host, $get_mysql_username, $get_mysql_password, $get_mysql_dbname);
if($conn) {
function deleteDir() {
    if(unlink("index.php") && unlink("db.sql")) {
        return 1;
    }
}
$get_sql_file = file_get_contents('db.sql');
$mysqli = new mysqli($get_mysql_host, $get_mysql_username, $get_mysql_password, $get_mysql_dbname);
if($mysqli->multi_query($get_sql_file)) {
    $config_file = fopen("../.env", "w") or die(".env Dosyası oluşturulurken bir hata meydana geldi! Lütfen yazma izinlerini kontrol edin.");
    $data = "APP_NAME=Laravel
APP_ENV=local
APP_KEY=base64:2mFoJctndDTHo8QoGuWUKwM7eMcFBcMa6MC2Hs2fwaw=
APP_DEBUG=true
APP_URL=http://localhost

LOG_CHANNEL=stack
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=debug

DB_CONNECTION=mysql
DB_HOST=$get_mysql_host
DB_PORT=3306
DB_DATABASE=$get_mysql_dbname
DB_USERNAME=$get_mysql_username
DB_PASSWORD=$get_mysql_password

BROADCAST_DRIVER=log
CACHE_DRIVER=database
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

MEMCACHED_HOST=127.0.0.1

REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

MAIL_MAILER=smtp
MAIL_HOST=mailhog
MAIL_PORT=1025
MAIL_USERNAME=null
MAIL_PASSWORD=null
MAIL_ENCRYPTION=null
MAIL_FROM_ADDRESS=\"hello@example.com\"
MAIL_FROM_NAME=\"\${APP_NAME}\"

AWS_ACCESS_KEY_ID=
AWS_SECRET_ACCESS_KEY=
AWS_DEFAULT_REGION=us-east-1
AWS_BUCKET=\
AWS_USE_PATH_STYLE_ENDPOINT=false

PUSHER_APP_ID=
PUSHER_APP_KEY=
PUSHER_APP_SECRET=
PUSHER_HOST=
PUSHER_PORT=443
PUSHER_SCHEME=https
PUSHER_APP_CLUSTER=mt1

VITE_PUSHER_APP_KEY=\"\${PUSHER_APP_KEY}\"
VITE_PUSHER_HOST=\"\${PUSHER_HOST}\"
VITE_PUSHER_PORT=\"\${PUSHER_PORT}\"
VITE_PUSHER_SCHEME=\"\${PUSHER_SCHEME}\"
VITE_PUSHER_APP_CLUSTER=\"\${PUSHER_APP_CLUSTER}\"";
    fwrite($config_file, $data);
    fclose($config_file);
    sleep(2);
    $user_file = fopen("../kullaniciadi.php", "w") or die("kullaniciadi.php Dosyası oluşturulurken bir hata meydana geldi! Lütfen yazma izinlerini kontrol edin.");
    $user_file_data = "<?php\n\$script_user = \"$get_script_user\";\n?>";
    fwrite($user_file, $user_file_data);
    fclose($user_file);

    $htaccess = fopen("../.htaccess", "w") or die(".htaccess Dosyası oluşturulurken bir hata meydana geldi! Lütfen yazma izinlerini kontrol edin.");
    $htaccess_data = "
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteRule ^$ public/index.php [L]
    RewriteRule ^((?!public/).*)$ public/$1 [L,NC]
</IfModule>
";
    fwrite($htaccess, $htaccess_data);
    fclose($htaccess);

    $admin_import_conn = mysqli_connect($get_mysql_host, $get_mysql_username, $get_mysql_password, $get_mysql_dbname);
    $admin_import_sql = "INSERT INTO `users` (`name`, `surname`, `phone`, `email`, `email_verified_at`, `password`, `remember_token`, `created_at`, `updated_at`, `role`, `ip`, `ban`, `wallet`, `google_id`) VALUES
    ('$get_admin_username', NULL, '000000000', '$get_admin_email', NULL, '$get_admin_password', NULL, '2023-01-17 11:41:24', '2023-01-17 11:41:24', 1, NULL, 0, '0.00', NULL);";
    $admin_user_import = mysqli_query($admin_import_conn, $admin_import_sql);
    if($admin_user_import) {
        if(deleteDir()) {
            echo '<script>location.replace("../");</script>';
        } else {
          echo '<script>location.replace("../");</script>';
        }
    } else {
        echo '<script>Swal.fire("Bir Hata oluştu", "Yönetici hesabı oluşturulurken bir hata oluştu.", "error"); </script>';
    }
    mysqli_close($conn);
    mysqli_close($admin_import_conn);
} else {
    echo '<script>Swal.fire("Bir Hata oluştu", "Veritabanı tabloları içe aktarılırken bir hata oluştu.", "error"); </script>';
}

} else {
    echo '<script>Swal.fire("Bir Hata oluştu", "Lütfen veritabanı bilgilerini kontrol edin.", "error"); </script>';
}
}
?>
    <section class="container header active" id="home">
        <h2 style="text-align: center;color: green;">Kurulum Aracı</h2><br>
        <form method="POST" action="">
        <h2 style="text-align: center;">Veritabanı Ayarları</h2><br>
        <p>MySQL Host:</p>
        <input name="mysql_host" type="text" placeholder="localhost" value="localhost" style="border-radius: 30px;font-weight: inherit;font-size: inherit;font-family: inherit;padding: 0.8rem 1.1rem;outline: none;border: none;background-color: var(--color-grey-5);width: 100%;color: var(--color-white);resize: none;" required>
        <p>MySQL Kullanıcı Adı:</p>
        <input name="mysql_username" type="text" placeholder="MySQL Kullanıcı Adı" style="border-radius: 30px;font-weight: inherit;font-size: inherit;font-family: inherit;padding: 0.8rem 1.1rem;outline: none;border: none;background-color: var(--color-grey-5);width: 100%;color: var(--color-white);resize: none;" required>
        <p>MySQL Veritabanı Adı:</p>
        <input name="mysql_dbname" type="text" placeholder="MySQL Veritabanı Adı" style="border-radius: 30px;font-weight: inherit;font-size: inherit;font-family: inherit;padding: 0.8rem 1.1rem;outline: none;border: none;background-color: var(--color-grey-5);width: 100%;color: var(--color-white);resize: none;" required>
        <p>MySQL Şifre:</p>
        <input name="mysql_password" type="password" placeholder="MySQL Şifre" style="border-radius: 30px;font-weight: inherit;font-size: inherit;font-family: inherit;padding: 0.8rem 1.1rem;outline: none;border: none;background-color: var(--color-grey-5);width: 100%;color: var(--color-white);resize: none;" required>
        <br><br>

        <h2 style="text-align: center;">Yönetici Hesabı Bilgileri</h2><br>
        <p>Yönetici Kullanıcı Adı:</p>
        <input name="admin_username" type="text" placeholder="Yönetici Kullanıcı Adı" style="border-radius: 30px;font-weight: inherit;font-size: inherit;font-family: inherit;padding: 0.8rem 1.1rem;outline: none;border: none;background-color: var(--color-grey-5);width: 100%;color: var(--color-white);resize: none;" required>
        <p>Yönetici Email:</p>
        <input name="admin_email" type="email" placeholder="Yönetici Email" style="border-radius: 30px;font-weight: inherit;font-size: inherit;font-family: inherit;padding: 0.8rem 1.1rem;outline: none;border: none;background-color: var(--color-grey-5);width: 100%;color: var(--color-white);resize: none;" required>
        <p>Yönetici Şifre:</p>
        <input name="admin_password" type="password" placeholder="Yönetici Şifre" style="border-radius: 30px;font-weight: inherit;font-size: inherit;font-family: inherit;padding: 0.8rem 1.1rem;outline: none;border: none;background-color: var(--color-grey-5);width: 100%;color: var(--color-white);resize: none;" required>
        <br><br>
        <p>Scripti Kim Kullanıyor:</p>
        <input name="script_user" type="text" placeholder="Script Kullanıcısı" style="border-radius: 30px;font-weight: inherit;font-size: inherit;font-family: inherit;padding: 0.8rem 1.1rem;outline: none;border: none;background-color: var(--color-grey-5);width: 100%;color: var(--color-white);resize: none;" required>
        <br><br>
        <button type="submit" name="install_submit" style="border-radius: 30px;font-weight: inherit;font-size: inherit;font-family: inherit;padding: 0.8rem 1.1rem;outline: none;border: none;background-color: green;width: 100%;color: var(--color-white);resize: none;cursor: pointer;">
            <span style="color:white;">Kur</span>
        </button>
        </form>
    </section>
    <script src="../app.js"></script>
</body>
</html>